define(['angular', 'app'], function(angular, app) {
	app.constant('LearnMoreConstants', {
		'fitness': {
			'scope': {
				'groups': [
					{
						'id': 1,
						'title': 'Safety First',
						'content': 'Exercise is safe and benefits most people.  Talk with your health provider if you want to know if a certian type of exercise is safe for you.'
					}, {
						'id': 2,
						'title': 'Be Active',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-be-active_template.html'
					}, {
						'id': 3,
						'title': 'Cardiac Rehab',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-cardiac-rehab_template.html'
					}, {
						'id': 4,
						'title': 'How-To',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-how-to_template.html'
					}, {
						'id': 5,
						'title': 'Rate Intensity',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-intensity_template.html'
					}, {
						'id': 6,
						'title': 'Examples',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-examples_template.html'
					}, {
						'id': 7,
						'title': 'Benefits',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-benefits_template.html'
					}, {
						'id': 8,
						'title': 'Counting Steps',
						'content': 'Many people like using a pedometer to measure their physical activity. A pedometer counts the number of steps that you take in a day.  Try to take 10,000 steps every day.'
					}, {
						'id': 9,
						'title': 'Amount',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-amount_template.html'
					}, {
						'id': 10,
						'title': 'Links',
						'template': 'src/modules/learn-more/pages/summary/partials/fitness-links_template.html'
					}
				]
			}
		},
		'health': {
			'scope': {
				'groups': [{
					'id': 1,
					'title': 'Quick Tips',
					'template': 'src/modules/learn-more/pages/summary/partials/health-quick-tips_template.html'
				}, {
					'id': 2,
					'title': 'Blood Pressure',
					'template': 'src/modules/learn-more/pages/summary/partials/health-blood-pressure_template.html'
				}, {
					'id': 3,
					'title': 'Cholesterol',
					'template': 'src/modules/learn-more/pages/summary/partials/health-cholesterol_template.html'
				}, {
					'id': 4,
					'title': 'Smoking',
					'template': 'src/modules/learn-more/pages/summary/partials/health-smoking_template.html'
				}, {
					'id': 5,
					'title': 'Quit Smoking Apps',
					'template': 'src/modules/learn-more/pages/summary/partials/health-quit-smoking-apps_template.html'
				}, {
					'id': 6,
					'title': 'Diabetes',
					'template': 'src/modules/learn-more/pages/summary/partials/health-diabetes_template.html'
				}, {
					'id': 7,
					'title': 'Diabetes Apps',
					'template': 'src/modules/learn-more/pages/summary/partials/health-diabetes-apps_template.html'
				}, {
					'id': 8,
					'title': 'Medications',
					'template': 'src/modules/learn-more/pages/summary/partials/health-medications_template.html'
				}, {
					'id': 9,
					'title': 'Links',
					'template': 'src/modules/learn-more/pages/summary/partials/health-links_template.html'
				}]
			}
		},
		'nutrition': {
			'scope': {
				'groups': [
					{
						'id': 1,
						'title': 'Quick Tips',
						'template': 'src/modules/learn-more/pages/summary/partials/nutrition-quick-tips_template.html'
					}, {
						'id': 2,
						'title': 'Weight',
						'template': 'src/modules/learn-more/pages/summary/partials/nutrition-weight_template.html'
					}, {						
						'id': 3,
						'title': 'Calories',
						'template': 'src/modules/learn-more/pages/summary/partials/nutrition-calories_template.html'
					}, {
						'id': 4,
						'title': 'Weight Apps',
						'template': 'src/modules/learn-more/pages/summary/partials/nutrition-weight-apps_template.html'
					}, {
						'id': 5,
						'title': 'Links',
						'template': 'src/modules/learn-more/pages/summary/partials/nutrition-links_template.html'
					}
				]
			}
		},
		'mood': {
			'scope': {
				'groups': [
					{
						'id': 1,
						'title': 'Quick Tips',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-quick-tips_template.html'
					}, {
						'id': 2,
						'title': 'Breathing',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-breathing_template.html'
					}, {
						'id': 3,
						'title': 'Positive Events',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-positive-events_template.html'
					}, {
						'id': 4,
						'title': 'Gratitude',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-gratitude_template.html'
					}, {
						'id': 5,
						'title': 'Silver Lining',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-silver-lining_template.html'
					}, {
						'id': 6,
						'title': 'Personal Strengths',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-personal-strengths_template.html'
					}, {
						'id': 7,
						'title': 'Acts of Kindness',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-acts-of-kindness_template.html'
					}, {
						'id': 8,
						'title': 'Video',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-video_template.html'
					}, {
						'id': 9,
						'title': 'Links',
						'template': 'src/modules/learn-more/pages/summary/partials/mood-links_template.html'
					}
				]
			}
		}
	});
});